import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Form, TextArea, Checkbox} from 'react-form';
import MeteoSelect from "../Fields/MeteoSelect/MeteoSelect";
import LimpidezzaSelect from "../Fields/LimpidezzaSelect/LimpidezzaSelect";
import SpeciesChooser from "../Fields/SpeciesChooser/SpeciesChooser";
import Typeahead from "../Fields/Typeahead/Typeahead";
import Text from "../Fields/Text/Text";
import DateTime from "../Fields/DateTime/DateTime";
import TipologiaMonitoraggioSelect from "../Fields/TipologiaMonitoraggioSelect/TipologiaMonitoraggioSelect";
import {sitoNatura2000SmartFilterQuery} from "../../../api/queries";
import ReactTable from "react-table";
import Loading from "../../Loading/Loading";
import {withApollo} from "react-apollo";
import {findById} from "../../../utils";
import {withRouter} from "react-router-dom";
import MonitoraggioSpecieDocumenti from "./MonitoraggioSpecieDocumenti";
import MonitoraggioSpecieRilievi from "./MonitoraggioSpecieRilievi/MonitoraggioSpecieRilievi"
import MonitoraggioSpecieSegnalazioniAltreSpecie from './MonitoraggioSpecieSegnalazioniAltreSpecie/MonitoraggioSpecieSegnalazioniAltreSpecie'
import Permissions from "../../../permissions";

class MonitoraggioSpecieFormComponent extends Component {

  constructor(props) {
    super(props);

    this.state = {
      submitting: false,
      error: false,
    };
    this.onSubmit = this.onSubmit.bind(this);
  }

  onSubmit(values) {

    const {client, submitMutation, data} = this.props;

    this.setState({submitting: true});

    let variables = {
      monitoraggio: {
        ...values,
        specie: values.specie.id ? { id: values.specie.id, }: null,
        sitoNatura2000: values.sitoNatura2000 ? { id: values.sitoNatura2000[0].id } : null,
        temperaturaAria: values.temperaturaAria ? parseFloat(values.temperaturaAria) : null,
        umiditaRelativa: values.umiditaRelativa ? parseFloat(values.umiditaRelativa) : null,
        profonditaMinAcqua: values.profonditaMinAcqua ? parseFloat(values.profonditaMinAcqua) : null,
        profonditaMaxAcqua: values.profonditaMaxAcqua ? parseFloat(values.profonditaMaxAcqua) : null,
        pH: values.pH ? parseFloat(values.pH) : null,
        conducibilita: values.conducibilita ? parseFloat(values.conducibilita) : null,
        visibilitaAcqua: values.visibilitaAcqua ? parseFloat(values.visibilitaAcqua) : null,
        temperaturaAcquaInizioTransetto: values.temperaturaAcquaInizioTransetto ? parseFloat(values.temperaturaAcquaInizioTransetto) : null,
        temperaturaAcquaFineTransetto: values.temperaturaAcquaFineTransetto ? parseFloat(values.temperaturaAcquaInizioTransetto) : null,
        limpidezza: values.limpidezza ? {id: values.limpidezza}: null,
        meteoInizio: values.meteoInizio ? {id: values.meteoInizio}: null,
        meteoFine: values.meteoFine ? {id: values.meteoFine}: null,
        tipologiaMonitoraggio: values.tipologiaMonitoraggio ? {id: values.tipologiaMonitoraggio}: null,
      }
    };

    delete variables.monitoraggio.__typename;

    if(data && data.id) {
      variables.monitoraggio.id = data.id;
    }

    client.mutate({
      mutation: submitMutation,
      variables: variables,
    }).then(res => {
      this.props.data.refetch()
		this.setState({
                submitting: false,
            })
	   if (!variables.monitoraggio.id) window.location.href='/LifeEremitaWeb/species/'+res.data.updateMonitoraggioSpecie.id+'/edit'
      /*if(this.props.onSubmitComplete) {
        this.props.onSubmitComplete();
      } else {
        this.props.history.goBack();
      }*/
    }).catch(err => {
      console.log(err);
      this.setState({
        submitting: false,
        error: true,
      });
    });
  }

  render() {
    const {
      data,
      readOnly,
      utenteSessione
    } = this.props;

    if(data && data.loading) {
      return(<Loading/>);
    }

	  console.log('monitoraggioSpecieForm')
	  console.log(this.props)

    return (
      <Form
        defaultValues={data.monitoraggioSpecie ? {
          ...data.monitoraggioSpecie,
          specie: data.monitoraggioSpecie.specie ? findById(data.specieProgettos, data.monitoraggioSpecie.specie.id): null,
          sitoNatura2000: data.monitoraggioSpecie.sitoNatura2000 ? [data.monitoraggioSpecie.sitoNatura2000]: null,
          meteoInizio: data.monitoraggioSpecie.meteoInizio ? data.monitoraggioSpecie.meteoInizio.id: null,
          meteoFine: data.monitoraggioSpecie.meteoFine ? data.monitoraggioSpecie.meteoFine.id: null,
          tipologiaMonitoraggio: data.monitoraggioSpecie.tipologiaMonitoraggio ? data.monitoraggioSpecie.tipologiaMonitoraggio.id: null,
          limpidezza: data.monitoraggioSpecie.limpidezza ? data.monitoraggioSpecie.limpidezza.id: null,
        } : null}
        onSubmit={this.onSubmit}>
        {(formApi) => <form onSubmit={formApi.submitForm}>
          <div className="row">
            <div className="col">
              <div className="form-group">
                <label htmlFor="specie">Specie</label>
                <SpeciesChooser field="specie" id="specie" />
              </div>
            </div>
          </div>
          {!formApi.values.specie && <div className="row">
            <div className="col">
              <h5>Informazioni Generali</h5>
              <div className="text-muted">Seleziona una specie per proseguire</div>
            </div>
          </div>}
          {formApi.values.specie && <div>
            <div className="row">
              <div className="col">
                <h5>Informazioni Generali</h5>
              </div>
            </div>
            <div className="row">
                <div className="col-md-6">
                    <div className="form-group">
                        <label htmlFor="checkbox-input-authorize" className="mr-2">Validato</label>
                        <Checkbox
                            field="validato"
                            id="checkbox-input-authorize"
                            disabled={utenteSessione.loading ||
                            utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.validateMonitSpecie).length==0
                            }
                        />
                    </div>
                </div>
            </div>
            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="idScheda">ID Scheda</label>
                  <Text
                    readOnly={readOnly}
                    field="idScheda"
                    id="idScheda"
                    type="text"
                    className="form-control" />
                </div>
              </div>
            </div>
            <div className="row">
              <div className="col-md-8">
                <div className="form-group">
                  <label htmlFor="sitoNatura2000">Sito Natura 2000</label>
                  <Typeahead
                    readOnly={readOnly}
                    dataQuery={sitoNatura2000SmartFilterQuery}
                    helpText={"Cerca un sito Natura 2000 per nome"}
                    searchText={"Ricerca in corso..."}
                    paginationText={"Mostra di più..."}
                    emptyLabel={"Nessun sito trovato."}
                    promptText={"Scrivi per cercare..."}
                    labelKey={"nome"}
                    filterKey={"testo"}
                    resultKey={"sitoNatura2000SmartFilter"}
                    field="sitoNatura2000"
                    id="sitoNatura2000"
                    className="form-control"
                    placeholder={""} />
                </div>
              </div>
            </div>

            <div className="row">
              <div className="col-md-8">
                <div className="form-group">
                  <label htmlFor="rilevatori">Rilevatore/i</label>
                  <Text field="rilevatori"
                        readOnly={readOnly}
                        id="rilevatori"
                        type="text"
                        className="form-control" />
                </div>
              </div>
            </div>

            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="inizioRilievo">Data e Ora Inizio Rilievo</label>
                  <DateTime readOnly={readOnly} id="inizioRilievo" field="inizioRilievo" />
                </div>
              </div>
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="fineRilievo">Data e Ora Fine Rilievo</label>
                  <DateTime readOnly={readOnly} id="fineRilievo" field="fineRilievo" />
                </div>
              </div>
            </div>

            <div className="row">

              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="transetto">Transetto Rilievo</label>
                  <Text readOnly={readOnly} id="transetto"
                        field="transetto"
                        type="text"
                        className="form-control" />
                </div>
              </div>
            </div>

            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="meteoInizio">Condizioni Meteo Inizio Rilievo</label>
                  <MeteoSelect
                    readOnly={readOnly}
                    id="meteoInizio"
                    field="meteoInizio"
                    className="form-control"/>
                </div>
              </div>
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="meteoFine">Condizioni Meteo Fine Rilievo</label>
                  <MeteoSelect
                    readOnly={readOnly}
                    id="meteoFine"
                    field="meteoFine"
                    className="form-control"/>
                </div>
              </div>
            </div>

            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label>Temperatura dell'aria</label>
                  <Text id="temperaturaAria"
                        readOnly={readOnly}
                        field="temperaturaAria"
                        type="number"
                        className="form-control" />
                </div>
              </div>
              <div className="col-md-6">
                <div className="form-group">
                  <label>Umidità Relativa</label>
                  <Text id="umiditaRelativa"
                        readOnly={readOnly}
                        field="umiditaRelativa"
                        type="number"
                        className="form-control" />
                </div>
              </div>
            </div>

            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="vento">Velocità/direzione vento</label>
                  <Text id="vento"
                        readOnly={readOnly}
                        field="vento"
                        type="text"
                        className="form-control" />
                </div>
              </div>
            </div>

            <div className="row">
              <div className="col-md-6">
                <div className="form-group">
                  <label htmlFor="tipologiaMonitoraggio">Tipologia Monitoraggio</label>
                  <TipologiaMonitoraggioSelect
                    readOnly={readOnly}
                    id="tipologiaMonitoraggio"
                    field="tipologiaMonitoraggio"
                    className="form-control"/>
                </div>
              </div>
            </div>

            {data && <div>
              <div className="row">
                <div className="col">
                  <h5>Altre Informazioni</h5>
                </div>
              </div>
            </div>}

            {formApi.values.specie.acquatica === "true" && <div>
              <div className="row">
                <div className="col">
                  <div className="form-group">
                    <label htmlFor="profonditaMinAcqua">Profondità Minima Acqua</label>
                    <Text id="profonditaMinAcqua"
                          field="profonditaMinAcqua"
                          type="number"
                          className="form-control" />
                  </div>
                </div>
                <div className="col">
                  <div className="form-group">
                    <label htmlFor="profonditaMaxAcqua">Profondità Massima Acqua</label>
                    <Text id="profonditaMaxAcqua"
                          field="profonditaMaxAcqua"
                          type="number"
                          className="form-control" />
                  </div>
                </div>
              </div>
              <div className="row">
                <div className="col">
                  <div className="form-group">
                    <label htmlFor="pH">pH</label>
                    <Text id="pH"
                          field="pH"
                          type="number"
                          className="form-control" />
                  </div>
                </div>

                <div className="col">
                  <div className="form-group">
                    <label htmlFor="conducibilita">Conducibilità Acqua</label>
                    <Text id="conducibilita"
                          field="conducibilita"
                          type="number"
                          className="form-control" />
                  </div>
                </div>
              </div>

              <div className="row">
                <div className="col">
                  <div className="form-group">
                    <label htmlFor="limpidezza">Limpidezza Acqua</label>
                    <LimpidezzaSelect
                      id="limpidezza"
                      field="limpidezza"
                      className="form-control"/>
                  </div>
                </div>
                <div className="col">
                  <div className="form-group">
                    <label htmlFor="visibilitaAcqua">Visibilità Acqua</label>
                    <Text id="visibilitaAcqua"
                          field="visibilitaAcqua"
                          type="number"
                          className="form-control" />
                  </div>
                </div>
              </div>

              <div className="row">
                <div className="col">
                  <div className="form-group">
                    <label htmlFor="temperaturaAcquaInizioTransetto">Temperatura Acqua Inizio Transetto</label>
                    <Text id="temperaturaAcquaInizioTransetto"
                          field="temperaturaAcquaInizioTransetto"
                          type="number"
                          className="form-control" />
                  </div>
                </div>

                <div className="col">
                  <div className="form-group">
                    <label htmlFor="temperaturaAcquaFineTransetto">Temperatura Acqua Fine Transetto</label>
                    <Text id="temperaturaAcquaFineTransetto"
                          field="temperaturaAcquaFineTransetto"
                          type="number"
                          className="form-control" />
                  </div>
                </div>
              </div>
            </div>}

            <div className="row">
              <div className="col">
                <div className="form-group">
                  <label htmlFor="note">Note</label>
                  <TextArea rows="3" field="note" id="note" className="form-control" />
                </div>
              </div>
            </div>

            <div className="row">
              <div className="col">
                <h5>Allegati al Monitoraggio</h5>
              </div>

            </div>

            {data.monitoraggioSpecie && <MonitoraggioSpecieDocumenti data={data}/>}

            <div className="row">
              <div className="col">
                <h5>Rilievi</h5>
              </div>
            </div>

            {data.monitoraggioSpecie && <MonitoraggioSpecieRilievi data={data}/>}

            <div className="row">
              <div className="col">
                <h5>Segnalazioni Altre Specie</h5>
              </div>
            </div>

            {data.monitoraggioSpecie && <MonitoraggioSpecieSegnalazioniAltreSpecie data={data} />}

            {this.state.submitting && <div className="row">
              <div className="col">
                <div className="text-info text-center">Caricamento in corso...</div>
              </div>
            </div>}

            {this.state.error && <div className="row">
              <div className="col">
                <div className="text-info text-center">Errore durante il salvataggio della scheda</div>
              </div>
            </div>}

            <div className="row">
              <div className="col">
                <button disabled={this.state.submitting} type="submit" className="btn btn-primary">
                  {data && data.monitoraggioSpecie && data.monitoraggioSpecie.id ? "SALVA SCHEDA" : "CREA NUOVA SCHEDA"}
                </button>
              </div>
            </div>
          </div>}
        </form>}
      </Form>);
  }
}

const MonitoraggioSpecieForm = withRouter(withApollo(MonitoraggioSpecieFormComponent));

MonitoraggioSpecieForm.defaultProps = {};

MonitoraggioSpecieForm.propTypes = {
  data: PropTypes.object,
  submitMutation: PropTypes.object.isRequired,
  errorMessage: PropTypes.string.isRequired,
  onSubmitComplete: PropTypes.func,
};

export default MonitoraggioSpecieForm;
